//
// (c) 2021 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12
import QtQuick.Layouts 1.12

import wesual.Stage  1.0

import wesual.Ui 1.0

MouseArea {
    id : delegate

    property bool supportsContextMenu : true
    property AreaGroup group : null

    signal requestSelect(var areaGroup)
    signal requestRemove(var areaGroup)

    implicitHeight : 28
    implicitWidth  : 200

    onDoubleClicked : requestSelect(group)

    RowLayout {
        anchors.fill : delegate
        anchors.margins : 2

        UiIcon {
            iconName : "content-group"
        }
        UiText {
            text : group.label

            Layout.fillWidth : true
        }
    }

    UiContextMenu {
        enabled : delegate.supportsContextMenu

        UiMenuItem {
            text : qsTrId("72fd25eaf2a053da")
            iconName : "visible"

            onTriggered : delegate.requestSelect(group)
        }
        UiMenuItem {
            text : qsTrId("a083ac3229c647ee")
            iconName : "remove"

            onTriggered : delegate.requestRemove(group);
        }
    }
}
